package net.w_horse.excelpojo.annotation;

import static org.junit.Assert.assertEquals;

import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import net.w_horse.excelpojo.AbstractTest;
import net.w_horse.excelpojo.ExcelPOJOBridge;
import net.w_horse.excelpojo.ExcelPOJOException;
import net.w_horse.excelpojo.excel.CellNotFoundException;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.junit.Test;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import test.annotation.AnnotationPriorityTest;
import test.annotation.AnnotationPriorityTestElement;
import test.annotation.AnnotationTest;
import test.annotation.AnnotationTestElement;
import test.annotation.AnnotationTestElementReadTableDirectly;
import test.annotation.AnnotationTestElementReadTableDirectlyArray;
import test.annotation.AnnotationTestElementReadTableDirectlyHorizontal;
import test.annotation.AnnotationTestElementReadTableDirectlyHorizontalArray;
import test.annotation.AnnotationTestElementReadTableDirectlyNoSpacifiedTerminate;
import test.annotation.AnnotationTestElementReadTableMargedRowsHorizontalRepeats;
import test.annotation.AnnotationTestElementReadTableMargedRowsNone;
import test.annotation.AnnotationTestElementReadTableMargedRowsSpacifiedByLabel;
import test.annotation.AnnotationTestElementReadTableMargedRowsVerticalRepeats;
import test.annotation.AnnotationTestElementReadTableUseNone;
import test.annotation.AnnotationTestElementReadTableUseOptional;
import test.annotation.AnnotationTestElementReadTableUseRequired;
import test.annotation.AnnotationTestSheetNameSpecifiedBy;
import test.annotation.DataFormatTest;
import test.annotation.DateFormatTest;
import test.annotation.LabeledCellMargedLabel;
import test.annotation.LabeledCellRetrieveFrom;
import test.annotation.LabeledCellUseRequired;

public class ExcelPOJOAnnotationParserTest extends AbstractTest {

	/**
	 * Ame[Vɂ{Iȓǂݏ̃eXg
	 * ʂ̃^CvE^ɂĂ̊mF
	 *
	 */
	@Test
	public void testReadAndSaveBasic() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTest.class);
		AnnotationTest targetBean = (AnnotationTest) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFLabeledCellFString", "P", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFint", 45, targetBean.getIntField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFboolean", true, targetBean.isBooleanField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFdouble", 78.56, targetBean.getDoubleField4LabeledCell1(), 0.001);
		assertEquals("{i擾jFLabeledCellFtij", "2010/06/18", targetBean.getDateField4LabeledCell1());

		assertEquals("{i擾jFPointedCellFString", "ʒuɂ錟F", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFPointedCellFint", 234, targetBean.getIntField4PointedCell1());
		assertEquals("{i擾jFPointedCellFboolean", false, targetBean.isBooleanField4PointedCell1());
		assertEquals("{i擾jFPointedCellFdouble", 963.2, targetBean.getDoubleField4PointedCell1(), 0.001);
		assertEquals("{i擾jFPointedCellFtij", "2010/06/22", targetBean.getDateField4PointedCell1());

		assertEquals("{i擾jFConstantValueFString", "ŒlF", targetBean.getStringField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFint", 258, targetBean.getIntField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFboolean", false, targetBean.isBooleanField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFdouble", 3.14, targetBean.getDoubleField4ConstantValue1(), 0.001);

		Map<String, String> countMembersMap = targetBean.getMapField4MappedCell1();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		List<AnnotationTestElement> listElm = targetBean.getList4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		AnnotationTestElement[] arrElm = targetBean.getArr4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", AnnotationTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		listElm = targetBean.getList4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		arrElm = targetBean.getArr4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", AnnotationTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}


		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_{.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_{.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "P", getCellValue(sheet, 42, 9, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 45, getCellValue(sheet, 43, 9, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", true, getCellValue(sheet, 44, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 78.56, (Double)getCellValue(sheet, 45, 9, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/06/18", getCellValue(sheet, 46, 9, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F", getCellValue(sheet, 14, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",234, getCellValue(sheet, 15, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",false, getCellValue(sheet, 16, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",963.2, (Double)getCellValue(sheet, 17, 3, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/06/22", getCellValue(sheet, 18, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 21, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 22, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 21, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 22, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 21, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 22, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 21, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 22, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 70, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 73, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 74, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 71, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 80, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 72, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 82, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 83, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 84, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 85, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 82, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 83, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 84, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 85, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 70, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 73, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 74, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 71, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 80, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 72, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 82, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 83, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 84, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 85, 5, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * Ame[Vɂ鐔l^̃tH[}bgɂ鍷ق̃eXg
	 *
	 */
	@Test
	public void testDataFormat() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(DataFormatTest.class);
		DataFormatTest targetBean = (DataFormatTest) bridge.load("./files/upload/ParserTest.xls", "eZ^Cv");

		assertEquals("eZ^Cv 01",1, targetBean.getData1());
		assertEquals("eZ^Cv 02","", targetBean.getData2());
		assertEquals("eZ^Cv 03",-1234, targetBean.getData3());
		assertEquals("eZ^Cv 04",-1234, targetBean.getData4());
		assertEquals("eZ^Cv 05",-1234, targetBean.getData5());
		assertEquals("eZ^Cv 06",-1234, targetBean.getData6());
		assertEquals("eZ^Cv 07",-1234, targetBean.getData7());
		assertEquals("eZ^Cv 08",-1234, targetBean.getData8());
		assertEquals("eZ^Cv 09",-1234, targetBean.getData9());
		assertEquals("eZ^Cv 10",-1234.56, targetBean.getData10(),0.000000000000001);
		assertEquals("eZ^Cv 11",-1234.56, targetBean.getData11(),0.000000000000001);
		assertEquals("eZ^Cv 12",-1234.56, targetBean.getData12(),0.000000000000001);
		assertEquals("eZ^Cv 13",-1234.56, targetBean.getData13(),0.000000000000001);
		assertEquals("eZ^Cv 14",-1234.56, targetBean.getData14(),0.000000000000001);
		assertEquals("eZ^Cv 15",-1234.56, targetBean.getData15(),0.000000000000001);
		assertEquals("eZ^Cv 16",-1234.56, targetBean.getData16(),0.000000000000001);
		assertEquals("eZ^Cv 17",-123456, targetBean.getData17());
		assertEquals("eZ^Cv 18",-123456, targetBean.getData18());
		assertEquals("eZ^Cv 19",-123456, targetBean.getData19());
		assertEquals("eZ^Cv 20",-123456, targetBean.getData20());
		assertEquals("eZ^Cv 21",-123456, targetBean.getData21());
		assertEquals("eZ^Cv 22",-123456.78, targetBean.getData22(),0.000000000000001);
		assertEquals("eZ^Cv 23",-123456.78, targetBean.getData23(),0.000000000000001);
		assertEquals("eZ^Cv 24",-123456.78, targetBean.getData24(),0.000000000000001);
		assertEquals("eZ^Cv 25",-123456.78, targetBean.getData25(),0.000000000000001);
		assertEquals("eZ^Cv 26",-123456.78, targetBean.getData26(),0.000000000000001);
		assertEquals("eZ^Cv 27",-123456, targetBean.getData27());
		assertEquals("eZ^Cv 28",-123456, targetBean.getData28());
		assertEquals("eZ^Cv 29",-123456.78, targetBean.getData29(),0.000000000000001);
		assertEquals("eZ^Cv 30",-123456.78, targetBean.getData30(),0.000000000000001);
		assertEquals("eZ^Cv 31",0.1234, targetBean.getData31(),0.000000000000001);
		assertEquals("eZ^Cv 32",0.1234, targetBean.getData32(),0.000000000000001);
		assertEquals("eZ^Cv 33",2, targetBean.getData33());
		assertEquals("eZ^Cv 34","_t", targetBean.getData34());
		assertEquals("eZ^Cv 35",-1234, targetBean.getData35());
		assertEquals("eZ^Cv 36","2010N623", targetBean.getData36());
		assertEquals("eZ^Cv 37",new BigInteger("-12345678901234500000"), targetBean.getData37());
		assertEquals("eZ^Cv 38",-1.23456789012345E12, targetBean.getData38(),0.000000000000001);
	}

	/**
	 * Ame[Vɂt^̃tH[}bg̍كeXg
	 *
	 */
	@Test
	public void testDateFormat() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(DateFormatTest.class);
		DateFormatTest targetBean = (DateFormatTest) bridge.load("./files/upload/ParserTest.xls", "ttH[}bg");

		assertEquals("ttH[}bg 01", "2010/1/2",targetBean.getDateStr1());
		assertEquals("ttH[}bg 02", "2-Jan-10",targetBean.getDateStr2());
		assertEquals("ttH[}bg 03", "2-Jan",targetBean.getDateStr3());
		assertEquals("ttH[}bg 04", "Jan-10",targetBean.getDateStr4());
		assertEquals("ttH[}bg 05", "9:03 AM",targetBean.getDateStr5());
		assertEquals("ttH[}bg 06", "9:03:04 AM",targetBean.getDateStr6());
		assertEquals("ttH[}bg 07", "9:03",targetBean.getDateStr7());
		assertEquals("ttH[}bg 08", "9:03:04",targetBean.getDateStr8());
		assertEquals("ttH[}bg 09", "2010/1/2 9:03",targetBean.getDateStr9());
		assertEquals("ttH[}bg 10", "1/2/10",targetBean.getDateStr10());
		assertEquals("ttH[}bg 11", "2010N12",targetBean.getDateStr11());
		assertEquals("ttH[}bg 12", "903",targetBean.getDateStr12());
		assertEquals("ttH[}bg 13", "90304b",targetBean.getDateStr13());
		assertEquals("ttH[}bg 14", "03:04",targetBean.getDateStr14());
		assertEquals("ttH[}bg 15", "03:04.0",targetBean.getDateStr15());
		assertEquals("ttH[}bg 16", "2010N1",targetBean.getDateStr16());
		assertEquals("ttH[}bg 17", "12",targetBean.getDateStr17());
		assertEquals("ttH[}bg 18", "H22.1.2",targetBean.getDateStr18());
		assertEquals("ttH[}bg 19", "22N12",targetBean.getDateStr19());
		assertEquals("ttH[}bg 20", "2010/01/02",targetBean.getDateStr20());
		assertEquals("ttH[}bg 21", "2010/01/02",targetBean.getDateStr21());
		assertEquals("ttH[}bg 22", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr22()), 0.0000000001);
		assertEquals("ttH[}bg 23", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr23()), 0.0000000001);
		assertEquals("ttH[}bg 24", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr24()), 0.0000000001);
		assertEquals("ttH[}bg 25", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr25()), 0.0000000001);
		assertEquals("ttH[}bg 26", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr26()), 0.0000000001);
		assertEquals("ttH[}bg 27", "2010/01/02",targetBean.getDateStr27());
		assertEquals("ttH[}bg 28", "2010/01/02",targetBean.getDateStr28());
		assertEquals("ttH[}bg 29", "2010/01/02",targetBean.getDateStr29());
		assertEquals("ttH[}bg 30", "2010/01/02",targetBean.getDateStr30());
		assertEquals("ttH[}bg 31", "2010/01/02",targetBean.getDateStr31());
		assertEquals("ttH[}bg 32", "2010/01/02",targetBean.getDateStr32());
		assertEquals("ttH[}bg 33", "2010/01/02",targetBean.getDateStr33());
		assertEquals("ttH[}bg 34", "2010/01/02",targetBean.getDateStr34());
		assertEquals("ttH[}bg 35", "2010/01/02",targetBean.getDateStr35());
		assertEquals("ttH[}bg 36", "2010/01/02",targetBean.getDateStr36());
		assertEquals("ttH[}bg 37", "2010/01/02",targetBean.getDateStr37());
		assertEquals("ttH[}bg 38", Double.parseDouble("40180.3771296296"),Double.parseDouble(targetBean.getDateStr38()), 0.0000000001);
		assertEquals("ttH[}bg 39", "2010/01/02",targetBean.getDateStr39());
		assertEquals("ttH[}bg 40", "2010/06/18",targetBean.getDateStr40());

	}

	/**
	 * XMLƃAme[V̗Dx̃eXg
	 *
	 */
	@Test
	public void testXMLPriorityThanAnnotation() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testXMLPriorityThanAnnotation");
		AnnotationPriorityTest targetBean = (AnnotationPriorityTest) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFLabeledCellFString", "2", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFint", 90, targetBean.getIntField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFboolean", false, targetBean.isBooleanField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFdouble", 12.34, targetBean.getDoubleField4LabeledCell1(), 0.001);
		assertEquals("{i擾jFLabeledCellFtij", "2010/05/26", targetBean.getDateField4LabeledCell1());

		assertEquals("{i擾jFPointedCellFString", "ʒuɂ錟F2", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFPointedCellFint", 753, targetBean.getIntField4PointedCell1());
		assertEquals("{i擾jFPointedCellFboolean", true, targetBean.isBooleanField4PointedCell1());
		assertEquals("{i擾jFPointedCellFdouble", 85.23, targetBean.getDoubleField4PointedCell1(), 0.001);
		assertEquals("{i擾jFPointedCellFtij", "2010/04/01", targetBean.getDateField4PointedCell1());

		assertEquals("{i擾jFConstantValueFString", "ŒlF", targetBean.getStringField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFint", 258, targetBean.getIntField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFboolean", false, targetBean.isBooleanField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFdouble", 3.14, targetBean.getDoubleField4ConstantValue1(), 0.001);

		Map<String, String> countMembersMap = targetBean.getMapField4MappedCell1();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"L[P", "L[Q", "L[R", "L[S"};
		String[] values = new String[]{"lP", "lQ", "lR", "lS"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		List<AnnotationPriorityTestElement> listElm = targetBean.getList4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, listElm.size());

		AnnotationPriorityTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		AnnotationPriorityTestElement[] arrElm = targetBean.getArr4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", AnnotationPriorityTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[2];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[3];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		listElm = targetBean.getList4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, listElm.size());

		elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		arrElm = targetBean.getArr4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", AnnotationPriorityTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[2];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[3];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_XMLD.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_XMLD.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "2", getCellValue(sheet, 42, 13, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 90, getCellValue(sheet, 43, 13, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", false, getCellValue(sheet, 44, 13, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 12.34, (Double)getCellValue(sheet, 45, 13, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/05/26", getCellValue(sheet, 46, 13, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F2", getCellValue(sheet, 14, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",753, getCellValue(sheet, 15, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",true, getCellValue(sheet, 16, 6, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",85.23, (Double)getCellValue(sheet, 17, 6, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/04/01", getCellValue(sheet, 18, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","L[P", getCellValue(sheet, 41, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","lP",   getCellValue(sheet, 42, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","L[Q", getCellValue(sheet, 41, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","lQ",   getCellValue(sheet, 42, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","L[R", getCellValue(sheet, 41, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","lR",   getCellValue(sheet, 42, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","L[S", getCellValue(sheet, 41, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","lS",   getCellValue(sheet, 42, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 70, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 73, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 74, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 71, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 80, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 72, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 82, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 83, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 84, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 85, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 82, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 83, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 84, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 85, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 70, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 73, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 74, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 71, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 80, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 72, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 82, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 83, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 84, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 85, 5, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * XMLƃAme[V̗Dx̃eXgiו\̗vfj
	 *
	 */
	@Test
	public void testXMLPriorityThanAnnotationElement() throws ExcelPOJOException, IOException {
		ApplicationContext context = new ClassPathXmlApplicationContext("./config/XMLTests.xml");
		ExcelPOJOBridge bridge = (ExcelPOJOBridge)context.getBean("testXMLPriorityThanAnnotationElement");
		AnnotationPriorityTest targetBean = (AnnotationPriorityTest) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFLabeledCellFString", "P", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFint", 45, targetBean.getIntField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFboolean", true, targetBean.isBooleanField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFdouble", 78.56, targetBean.getDoubleField4LabeledCell1(), 0.001);
		assertEquals("{i擾jFLabeledCellFtij", "2010/06/18", targetBean.getDateField4LabeledCell1());

		assertEquals("{i擾jFPointedCellFString", "ʒuɂ錟F", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFPointedCellFint", 234, targetBean.getIntField4PointedCell1());
		assertEquals("{i擾jFPointedCellFboolean", false, targetBean.isBooleanField4PointedCell1());
		assertEquals("{i擾jFPointedCellFdouble", 963.2, targetBean.getDoubleField4PointedCell1(), 0.001);
		assertEquals("{i擾jFPointedCellFtij", "2010/06/22", targetBean.getDateField4PointedCell1());

		assertEquals("{i擾jFConstantValueFString", "ŒlF", targetBean.getStringField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFint", 258, targetBean.getIntField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFboolean", false, targetBean.isBooleanField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFdouble", 3.14, targetBean.getDoubleField4ConstantValue1(), 0.001);

		Map<String, String> countMembersMap = targetBean.getMapField4MappedCell1();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		List<AnnotationPriorityTestElement> listElm = targetBean.getList4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, listElm.size());

		AnnotationPriorityTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Vmn", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "^C", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		AnnotationPriorityTestElement[] arrElm = targetBean.getArr4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", AnnotationPriorityTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "^P_", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "I_", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[2];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "gNK", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[3];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "z\J", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		listElm = targetBean.getList4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, listElm.size());

		elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "VmnH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "^CH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		arrElm = targetBean.getArr4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", AnnotationPriorityTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "^P_H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "I_H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[2];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "gNKH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[3];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "z\JH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/XMLParserTest_XMLD().xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/XMLParserTest_XMLD().xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "P", getCellValue(sheet, 42, 9, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 45, getCellValue(sheet, 43, 9, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", true, getCellValue(sheet, 44, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 78.56, (Double)getCellValue(sheet, 45, 9, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/06/18", getCellValue(sheet, 46, 9, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F", getCellValue(sheet, 14, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",234, getCellValue(sheet, 15, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",false, getCellValue(sheet, 16, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",963.2, (Double)getCellValue(sheet, 17, 3, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/06/22", getCellValue(sheet, 18, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 21, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 22, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 21, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 22, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 21, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 22, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 21, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 22, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "^P_", getCellValue(sheet, 3, 7, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "I_", getCellValue(sheet, 4, 7, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "gNK", getCellValue(sheet, 5, 7, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "z\J", getCellValue(sheet, 6, 7, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Vmn", getCellValue(sheet, 29, 10, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "^C", getCellValue(sheet, 30, 10, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "^P_H", getCellValue(sheet, 55, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "I_H", getCellValue(sheet, 55, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "gNKH", getCellValue(sheet, 55, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "z\JH", getCellValue(sheet, 55, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 61, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 70, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "VmnH", getCellValue(sheet, 76, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 74, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 71, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 80, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 72, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 82, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 83, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 84, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 85, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 82, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 83, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 84, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 85, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 70, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "^CH", getCellValue(sheet, 76, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 74, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 71, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 80, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 72, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 82, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 83, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 84, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 85, 5, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * Ame[Vɂ\̒ړIȓǂݏ̃eXg
	 * cɃR[hJԂP[X
	 * Listɂ擾
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectly1() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableDirectly.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableDirectly> listElm = (List<AnnotationTestElementReadTableDirectly>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElementReadTableDirectly elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * Ame[Vɂ\̒ړIȓǂݏ̃eXg
	 * cɃR[hJԂP[X
	 * zɂ擾
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectly2() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableDirectlyArray.class);
		AnnotationTestElementReadTableDirectlyArray[] arrElm = (AnnotationTestElementReadTableDirectlyArray[]) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFArray", AnnotationTestElementReadTableDirectlyArray[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		AnnotationTestElementReadTableDirectlyArray elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"90", "56", "81", "23"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂Q.xls",
				arrElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂Q.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * Ame[Vɂ\̒ړIȓǂݏ̃eXg
	 * ɃR[hJԂP[X
	 * Listɂ擾
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectly3() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableDirectlyHorizontal.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableDirectlyHorizontal> listElm = (List<AnnotationTestElementReadTableDirectlyHorizontal>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElementReadTableDirectlyHorizontal elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂R.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂R.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * Ame[Vɂ\̒ړIȓǂݏ̃eXg
	 * ɃR[hJԂP[X
	 * zɂ擾
	 *
	 */
	@Test
	public void testReadAndSaveTableDirectly4() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableDirectlyHorizontalArray.class);
		AnnotationTestElementReadTableDirectlyHorizontalArray[] arrElm = (AnnotationTestElementReadTableDirectlyHorizontalArray[]) bridge.load("./files/upload/ParserTest.xls", "{");

		AnnotationTestElementReadTableDirectlyHorizontalArray elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"90", "56", "81", "23"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂S.xls",
				arrElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂S.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 70, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 73, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 74, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 71, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 80, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 72, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 82, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 83, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 84, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 85, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 82, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 83, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 84, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 85, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 70, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 73, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 74, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 71, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 80, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 72, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 82, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 83, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 84, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 85, 5, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * Ame[VɂV[gw̃eXg
	 *
	 */
	@Test
	public void testReadAndSaveSpecifySheetNameAtAnnotaton() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestSheetNameSpecifiedBy.class);
		AnnotationTestSheetNameSpecifiedBy targetBean = (AnnotationTestSheetNameSpecifiedBy) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFLabeledCellFString", "P", targetBean.getStringField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFint", 45, targetBean.getIntField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFboolean", true, targetBean.isBooleanField4LabeledCell1());
		assertEquals("{i擾jFLabeledCellFdouble", 78.56, targetBean.getDoubleField4LabeledCell1(), 0.001);
		assertEquals("{i擾jFLabeledCellFtij", "2010/06/18", targetBean.getDateField4LabeledCell1());

		assertEquals("{i擾jFPointedCellFString", "ʒuɂ錟F", targetBean.getStringField4PointedCell1());
		assertEquals("{i擾jFPointedCellFint", 234, targetBean.getIntField4PointedCell1());
		assertEquals("{i擾jFPointedCellFboolean", false, targetBean.isBooleanField4PointedCell1());
		assertEquals("{i擾jFPointedCellFdouble", 963.2, targetBean.getDoubleField4PointedCell1(), 0.001);
		assertEquals("{i擾jFPointedCellFtij", "2010/06/22", targetBean.getDateField4PointedCell1());

		assertEquals("{i擾jFConstantValueFString", "ŒlF", targetBean.getStringField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFint", 258, targetBean.getIntField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFboolean", false, targetBean.isBooleanField4ConstantValue1());
		assertEquals("{i擾jFConstantValueFdouble", 3.14, targetBean.getDoubleField4ConstantValue1(), 0.001);

		Map<String, String> countMembersMap = targetBean.getMapField4MappedCell1();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, countMembersMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, countMembersMap.keySet().size());

		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"0", "0", "1", "4"};
		int i = 0;
		for (String key : countMembersMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], countMembersMap.get(key));
			i++;
		}

		List<AnnotationTestElement> listElm = targetBean.getList4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElement elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		AnnotationTestElement[] arrElm = targetBean.getArr4VerticalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", AnnotationTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		listElm = targetBean.getList4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"160", "182", "165", "177"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		arrElm = targetBean.getArr4HorizontalRepeats1();
		assertEquals("{i擾jFVerticalRepeatsFArray", AnnotationTestElement[].class, arrElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 2, arrElm.length);

		elm = arrElm[0];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "܂H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 156.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N615", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"90", "56", "81", "23"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = arrElm[1];
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 168.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N617", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"112", "186", "78", "140"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}


		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_{.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_{.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFLabeledCellFString", "P", getCellValue(sheet, 42, 9, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFint", 45, getCellValue(sheet, 43, 9, CELL_TYPE_INT));
			assertEquals("{i݁jFLabeledCellFboolean", true, getCellValue(sheet, 44, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFLabeledCellFdouble", 78.56, (Double)getCellValue(sheet, 45, 9, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFLabeledCellFtij", "2010/06/18", getCellValue(sheet, 46, 9, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFPointedCellFString", "ʒuɂ錟F", getCellValue(sheet, 14, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFPointedCellFint",234, getCellValue(sheet, 15, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFPointedCellFboolean",false, getCellValue(sheet, 16, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFPointedCellFdouble",963.2, (Double)getCellValue(sheet, 17, 3, CELL_TYPE_DOUBLE), 0.001);
			assertEquals("{i݁jFPointedCellFtij","2010/06/22", getCellValue(sheet, 18, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 21, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","0",   getCellValue(sheet, 22, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 21, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","0",   getCellValue(sheet, 22, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 21, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","1",   getCellValue(sheet, 22, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 21, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","4",   getCellValue(sheet, 22, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 29, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 29, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂", getCellValue(sheet, 29, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 29, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 29, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 29, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 28, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 28, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 28, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 28, 17, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 29, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 29, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 29, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 29, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 30, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 30, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 30, 7, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 30, 8, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 30, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 30, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 30, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 30, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 30, 17, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 70, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 73, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "܂H", getCellValue(sheet, 74, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 71, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 156.0, (Double)getCellValue(sheet, 80, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N615", getCellValue(sheet, 72, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 82, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 83, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 84, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 85, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","90", getCellValue(sheet, 82, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","56", getCellValue(sheet, 83, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","81", getCellValue(sheet, 84, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","23", getCellValue(sheet, 85, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 70, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 73, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 74, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 71, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 168.5, (Double)getCellValue(sheet, 80, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N617", getCellValue(sheet, 72, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","112", getCellValue(sheet, 82, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","186", getCellValue(sheet, 83, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","78", getCellValue(sheet, 84, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","140", getCellValue(sheet, 85, 5, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * \̈ʒuɁAʒuipositionjw肵ۂ̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveTableSpecifiedByPosition() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableDirectlyHorizontal.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableDirectlyHorizontal> listElm = (List<AnnotationTestElementReadTableDirectlyHorizontal>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElementReadTableDirectlyHorizontal elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂R.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂R.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * \̓ǂݍ݂ɏI[iterminatejwsȂꍇ̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveTableNoSpacifiedTerminate() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableDirectlyNoSpacifiedTerminate.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableDirectlyNoSpacifiedTerminate> listElm = (List<AnnotationTestElementReadTableDirectlyNoSpacifiedTerminate>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 6, listElm.size());

		AnnotationTestElementReadTableDirectlyNoSpacifiedTerminate elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(4);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 5, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 155.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"400", "270", "240", "200"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(5);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 6, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "k", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "q", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 158.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N619", elm.getAdmissionDay());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"184", "197", "182", "178"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 91, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 91, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 91, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 91, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 91, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 91, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 90, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 90, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 90, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 90, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 91, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 91, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 91, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 91, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 92, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 92, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 92, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 92, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 92, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 92, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 92, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 92, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 92, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 92, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 93, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 93, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 93, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 93, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 93, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 93, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 93, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 93, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 93, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 93, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 94, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 94, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 94, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 94, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 94, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 94, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 94, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 94, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 94, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 94, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 5, getCellValue(sheet, 95, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 95, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 95, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 95, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 155.5, (Double)getCellValue(sheet, 95, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 95, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","400", getCellValue(sheet, 95, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","270", getCellValue(sheet, 95, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","240", getCellValue(sheet, 95, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","200", getCellValue(sheet, 95, 15, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 6, getCellValue(sheet, 96, 1, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "k", getCellValue(sheet, 96, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "q", getCellValue(sheet, 96, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 96, 8, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 158.0, (Double)getCellValue(sheet, 96, 10, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N619", getCellValue(sheet, 96, 9, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","184", getCellValue(sheet, 96, 12, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","197", getCellValue(sheet, 96, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","182", getCellValue(sheet, 96, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","178", getCellValue(sheet, 96, 15, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * \̓ǂݍ݂ɕK{wiuse=requiredjw肵ۂ̓eXg
	 * K{Y\Ȃꍇ˗O
	 */
	@SuppressWarnings("unchecked")
	@Test(expected=CellNotFoundException.class)
	public void testReadAndSaveTableUseRequired() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableUseRequired.class);
		@SuppressWarnings("unused")
		List<AnnotationTestElementReadTableUseRequired> targetBean = (List<AnnotationTestElementReadTableUseRequired>) bridge.load("./files/upload/ParserTest.xls", "{");
	}

	/**
	 * \̓ǂݍ݂ɔCӎwiuse=optionaljw肵ۂ̓eXg
	 * Y\Ȃꍇˋ̎w肳ꂽXgԂ
	 */
	@Test
	public void testReadAndSaveTableUseOptional() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableUseOptional.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableUseOptional> listElm = (List<AnnotationTestElementReadTableUseOptional>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 0, listElm.size());

	}

	/**
	 * \̓ǂݍ݂ɕK{ / Cӂ̎wsȂۂ̓eXg
	 * Y\Ȃꍇuse=optionalƓi̎w肳ꂽXgԂj
	 */
	@Test
	public void testReadAndSaveTableUseNone() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableUseNone.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableUseNone> listElm = (List<AnnotationTestElementReadTableUseNone>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 0, listElm.size());

	}

	/**
	 * xɂʒuɑ΂Af[^擾ʒuiretrieveFromj̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveLabeledCellRetrieveFrom() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(LabeledCellRetrieveFrom.class);
		LabeledCellRetrieveFrom targetBean = (LabeledCellRetrieveFrom) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");

		assertEquals("{i擾jFLabeledCellFString", "Ẽf[^", targetBean.getRetrievFromRight());
		assertEquals("{i擾jFLabeledCellFString", "̃f[^", targetBean.getRetrievFromBottom());
		assertEquals("{i擾jFLabeledCellFString", "̃f[^", targetBean.getRetrievFromLeft());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"xǂݍ݈ʒu",
				"./files/export/AnnotationParserTest_xǂݍ݈ʒu.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_xǂݍ݈ʒu.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("xǂݍ݈ʒu");

			assertEquals("{i݁jFLabeledCellFString", "Ẽf[^", getCellValue(sheet, 4, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "̃f[^", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "̃f[^", getCellValue(sheet, 4, 2, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * ꂽxɂf[^擾imargedLabelj̓eXg
	 *
	 */
	@Test
	public void testReadAndSaveLabeledCellMargedLabel() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(LabeledCellMargedLabel.class);
		LabeledCellMargedLabel targetBean = (LabeledCellMargedLabel) bridge.load("./files/upload/ParserTest.xls", "Users2");

		assertEquals("{i擾jFLabeledCellFString", "Xg", targetBean.getRetrievMargedLable0());
		assertEquals("{i擾jFLabeledCellFString", "ExcelPOJỎ", targetBean.getRetrievMargedLable1());
		assertEquals("{i擾jFLabeledCellFString", "XgiQj", targetBean.getRetrievMargedLableNone());

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"Users2",
				"./files/export/AnnotationParserTest_xA.xls",
				targetBean);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_xA.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("Users2");

			assertEquals("{i݁jFLabeledCellFString", "Xg", getCellValue(sheet, 1, 2, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "ExcelPOJỎ", getCellValue(sheet, 2, 2, CELL_TYPE_STRING));
			assertEquals("{i݁jFLabeledCellFString", "XgiQj", getCellValue(sheet, 1, 5, CELL_TYPE_STRING));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * l̏ȗɑ΂ǂݏ̃eXg
	 * \ŜɎwic̕\j̃P[X
	 *
	 */
	@Test
	public void testReadAndSaveTableMargedRowsSpacifiedByVerticalRepeats() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableMargedRowsVerticalRepeats.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableMargedRowsVerticalRepeats> listElm = (List<AnnotationTestElementReadTableMargedRowsVerticalRepeats>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElementReadTableMargedRowsVerticalRepeats elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 3, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 4, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 6, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * l̏ȗɑ΂ǂݏ̃eXg
	 * \ŜɎwic̕\j̃P[X
	 *
	 */
	@Test
	public void testReadAndSaveTableMargedRowsSpacifiedByHorizontalRepeats() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableMargedRowsHorizontalRepeats.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableMargedRowsHorizontalRepeats> listElm = (List<AnnotationTestElementReadTableMargedRowsHorizontalRepeats>) bridge.load("./files/upload/ParserTest.xls", "{");
		assertEquals("{i擾jFVerticalRepeatsFList", ArrayList.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElementReadTableMargedRowsHorizontalRepeats elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "cH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "DcH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "MH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "H", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍNH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "אH", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KVH", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂R.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂R.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 50, 3, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "cH", getCellValue(sheet, 53, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 3, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 59, 3, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 52, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 58, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 62, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 63, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 64, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 65, 2, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 62, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 63, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 3, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 65, 3, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 50, 4, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "DcH", getCellValue(sheet, 53, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "MH", getCellValue(sheet, 54, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 60, 4, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 59, 4, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 52, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 58, 4, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 62, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 63, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 64, 4, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 65, 4, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 50, 5, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "H", getCellValue(sheet, 53, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍNH", getCellValue(sheet, 54, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 5, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 59, 5, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 52, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 58, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 62, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 63, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 64, 5, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 65, 5, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 50, 6, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "אH", getCellValue(sheet, 53, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KVH", getCellValue(sheet, 54, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 60, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 59, 6, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 52, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 58, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 62, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 63, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 64, 6, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 65, 6, CELL_TYPE_DATE_STR));

		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * l̏ȗɑ΂ǂݏ̃eXg
	 * xƂɎw̃P[X
	 *
	 */
	@Test
	public void testReadAndSaveTableMargedRowsSpacifiedByLabel() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableMargedRowsSpacifiedByLabel.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableMargedRowsSpacifiedByLabel> listElm = (List<AnnotationTestElementReadTableMargedRowsSpacifiedByLabel>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElementReadTableMargedRowsSpacifiedByLabel elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 3, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 4, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 6, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * l̏ȗɑ΂ǂݏ̃eXg
	 * wȂ̃P[X 󗓂͋󗓂̂܂
	 *
	 */
	@Test
	public void testReadAndSaveTableMargedRowsSpacifiedNone() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(AnnotationTestElementReadTableMargedRowsNone.class);
		@SuppressWarnings("unchecked")
		List<AnnotationTestElementReadTableMargedRowsNone> listElm = (List<AnnotationTestElementReadTableMargedRowsNone>) bridge.load("./files/upload/ParserTest.xls", "{");

		assertEquals("{i擾jFVerticalRepeatsFList", Vector.class, listElm.getClass());
		assertEquals("{i擾jFVerticalRepeatsFsize()", 4, listElm.size());

		AnnotationTestElementReadTableMargedRowsNone elm = listElm.get(0);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 1, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "c", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 175.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N611", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "j", elm.getGender());
		Map<String, String> useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		String[] keys = new String[]{"5", "6", "7", "8"};
		String[] values = new String[]{"160", "182", "165", "177"};
		int i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(1);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 2, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "Dc", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "M", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", true, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 178.5, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N620", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"193", "188", "171", "165"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(2);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 3, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "ƍN", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 165.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N618", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"162", "155", "165", "166"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		elm = listElm.get(3);
		assertEquals("{i擾jFVerticalRepeats(Element)Fint", 4, elm.getId());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "א", elm.getFirstName());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "KV", elm.getLastName());
		assertEquals("{i擾jFVerticalRepeats(Element)Fboolean", false, elm.isPremiumMember());
		assertEquals("{i擾jFVerticalRepeats(Element)Fdouble", 160.0, elm.getTall(), 0.1);
		assertEquals("{i擾jFVerticalRepeats(Element)Ftij", "2010N622", elm.getAdmissionDay());
		assertEquals("{i擾jFVerticalRepeats(Element)FString", "", elm.getGender());
		useTimeMap = elm.getUseTimeMap();
		assertEquals("{i擾jFMappedCellFLinkedHashMap", LinkedHashMap.class, useTimeMap.getClass());
		assertEquals("{i擾jFMappedCellFsize()", 4, useTimeMap.keySet().size());
		keys = new String[]{"5", "6", "7", "8"};
		values = new String[]{"143", "177", "151", "182"};
		i = 0;
		for (String key : useTimeMap.keySet()) {
			assertEquals("{i擾jFMappedCellFkey" + i, keys[i], key);
			assertEquals("{i擾jFMappedCellFvalue" + i, values[i], useTimeMap.get(key));
			i++;
		}

		bridge.save(
				"./files/template/ParserTest_Template.xls",
				"{",
				"./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls",
				listElm);

		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream("./files/export/AnnotationParserTest_ڕ\ǂݍ݂P.xls");
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(fileInputStream));
			HSSFSheet sheet = workBook.getSheet("{");

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 1, getCellValue(sheet, 3, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "c", getCellValue(sheet, 3, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 3, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 3, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 175.5, (Double)getCellValue(sheet, 3, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N611", getCellValue(sheet, 3, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "j", getCellValue(sheet, 3, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFkey1","5", getCellValue(sheet, 2, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey2","6", getCellValue(sheet, 2, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey3","7", getCellValue(sheet, 2, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFkey4","8", getCellValue(sheet, 2, 16, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval1","160", getCellValue(sheet, 3, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","182", getCellValue(sheet, 3, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 3, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","177", getCellValue(sheet, 3, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 2, getCellValue(sheet, 4, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "Dc", getCellValue(sheet, 4, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "M", getCellValue(sheet, 4, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", true, getCellValue(sheet, 4, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 178.5, (Double)getCellValue(sheet, 4, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N620", getCellValue(sheet, 4, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 4, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","193", getCellValue(sheet, 4, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","188", getCellValue(sheet, 4, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","171", getCellValue(sheet, 4, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","165", getCellValue(sheet, 4, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 3, getCellValue(sheet, 5, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "ƍN", getCellValue(sheet, 5, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 5, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 165.0, (Double)getCellValue(sheet, 5, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N618", getCellValue(sheet, 5, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 5, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","162", getCellValue(sheet, 5, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","155", getCellValue(sheet, 5, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","165", getCellValue(sheet, 5, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","166", getCellValue(sheet, 5, 16, CELL_TYPE_DATE_STR));

			assertEquals("{i݁jFVerticalRepeats(Element)Fint", 4, getCellValue(sheet, 6, 2, CELL_TYPE_INT));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "א", getCellValue(sheet, 6, 5, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "KV", getCellValue(sheet, 6, 6, CELL_TYPE_STRING));
			assertEquals("{i݁jFVerticalRepeats(Element)Fboolean", false, getCellValue(sheet, 6, 9, CELL_TYPE_BOOLEAN));
			assertEquals("{i݁jFVerticalRepeats(Element)Fdouble", 160.0, (Double)getCellValue(sheet, 6, 11, CELL_TYPE_DOUBLE), 0.1);
			assertEquals("{i݁jFVerticalRepeats(Element)Ftij", "2010N622", getCellValue(sheet, 6, 10, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFVerticalRepeats(Element)FString", "", getCellValue(sheet, 6, 3, CELL_TYPE_STRING));
			assertEquals("{i݁jFMappedCellFval1","143", getCellValue(sheet, 6, 13, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval2","177", getCellValue(sheet, 6, 14, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval3","151", getCellValue(sheet, 6, 15, CELL_TYPE_DATE_STR));
			assertEquals("{i݁jFMappedCellFval4","182", getCellValue(sheet, 6, 16, CELL_TYPE_DATE_STR));
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}

	/**
	 * x̓ǂݍ݂ɕK{wiuse=requiredjw肵ۂ̓eXg
	 * K{Y\Ȃꍇ˗O
	 */
	@Test(expected=CellNotFoundException.class)
	public void testReadAndSaveLabeledCellUseRequired() throws ExcelPOJOException, IOException {
		ExcelPOJOBridge bridge = new ExcelPOJOBridge(LabeledCellUseRequired.class);
		@SuppressWarnings("unused")
		LabeledCellUseRequired targetBean = (LabeledCellUseRequired) bridge.load("./files/upload/ParserTest.xls", "xǂݍ݈ʒu");
	}

}
